/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import jline.CompletionHandler;
import jline.ConsoleReader;
import jline.CursorBuffer;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private static ResourceBundle loc = ResourceBundle.getBundle((class$jline$CandidateListCompletionHandler == null ? (class$jline$CandidateListCompletionHandler = CandidateListCompletionHandler.class$("jline.CandidateListCompletionHandler")) : class$jline$CandidateListCompletionHandler).getName());
    private boolean eagerNewlines = true;
    static /* synthetic */ Class class$jline$CandidateListCompletionHandler;

    public void setAlwaysIncludeNewline(boolean bl) {
        this.eagerNewlines = bl;
    }

    public boolean complete(ConsoleReader consoleReader, List list, int n) throws IOException {
        CursorBuffer cursorBuffer = consoleReader.getCursorBuffer();
        if (list.size() == 1) {
            String string = list.get(0).toString();
            if (string.equals(cursorBuffer.toString())) {
                return false;
            }
            CandidateListCompletionHandler.setBuffer(consoleReader, string, n);
            return true;
        }
        if (list.size() > 1) {
            String string = this.getUnambiguousCompletions(list);
            String string2 = cursorBuffer.toString();
            CandidateListCompletionHandler.setBuffer(consoleReader, string, n);
        }
        if (this.eagerNewlines) {
            consoleReader.printNewline();
        }
        CandidateListCompletionHandler.printCandidates(consoleReader, list, this.eagerNewlines);
        consoleReader.drawLine();
        return true;
    }

    public static void setBuffer(ConsoleReader consoleReader, String string, int n) throws IOException {
        while (consoleReader.getCursorBuffer().cursor > n && consoleReader.backspace()) {
        }
        consoleReader.putString(string);
        consoleReader.setCursorPosition(n + string.length());
    }

    public static final void printCandidates(ConsoleReader consoleReader, Collection arrayList, boolean bl) throws IOException {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet(arrayList);
        if (hashSet.size() > consoleReader.getAutoprintThreshhold()) {
            int n;
            if (!bl) {
                consoleReader.printNewline();
            }
            consoleReader.printString(MessageFormat.format(loc.getString("display-candidates"), new Integer(arrayList.size())) + " ");
            consoleReader.flushConsole();
            object2 = loc.getString("display-candidates-no");
            object = loc.getString("display-candidates-yes");
            while ((n = consoleReader.readCharacter(new char[]{((String)object).charAt(0), ((String)object2).charAt(0)})) != -1) {
                if (((String)object2).startsWith(new String(new char[]{(char)n}))) {
                    consoleReader.printNewline();
                    return;
                }
                if (((String)object).startsWith(new String(new char[]{(char)n}))) break;
                consoleReader.beep();
            }
        }
        if (hashSet.size() != arrayList.size()) {
            ArrayList arrayList2 = new ArrayList();
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (arrayList2.contains(object)) continue;
                arrayList2.add(object);
            }
            arrayList = arrayList2;
        }
        consoleReader.printNewline();
        consoleReader.printColumns(arrayList);
    }

    private final String getUnambiguousCompletions(List list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String[] stringArray = list.toArray(new String[list.size()]);
        String string = stringArray[0];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length() && this.startsWith(string.substring(0, i + 1), stringArray); ++i) {
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private final boolean startsWith(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith(string)) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

